/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.taskplanner.openweathermap;

import java.util.List;

import com.inet.annotations.JsonData;

/**
 * The weather data response from openweathermap.org<br>
 * This data is not complete and can be extended to provide the complete response data.
 */
@JsonData
public class WeatherData {

    private Sys           sys;
    private List<Weather> weather;
    private Main          main;
    private Wind          wind;
    private String        name;
    private int           cod;

    /**
     * Returns the sys data
     * @return the sys data
     */
    public Sys getSys() {
        return sys;
    }

    /**
     * Returns the list of wether information
     * @return the list of wether information
     */
    public List<Weather> getWeather() {
        return weather;
    }

    /**
     * Returns the main information
     * @return the main information
     */
    public Main getMain() {
        return main;
    }

    /**
     * Returns the wind information
     * @return the wind information
     */
    public Wind getWind() {
        return wind;
    }

    /**
     * Returns the name of the city
     * @return the name of the city
     */
    public String getName() {
        return name;
    }

    /**
     * Returns the response code. Should be 200 for a valid response.
     * @return the response code
     */
    public int getCod() {
        return cod;
    }

    /**
     * The sys information
     */
    @JsonData
    public static class Sys {
        private String country;
        private long   sunrise;
        private long   sunset;

        /**
         * Returns the country
         * @return the country
         */
        public String getCountry() {
            return country;
        }

        /**
         * Returns the timestamp of the sunrise
         * @return the timestamp of the sunrise
         */
        public long getSunrise() {
            return sunrise;
        }

        /**
         * Returns the timestamp of the sunset
         * @return the timestamp of the sunset
         */
        public long getSunset() {
            return sunset;
        }

    }

    /**
     * The weather information
     */
    @JsonData
    public static class Weather {
        private long   id;
        private String description;

        /**
         * Returns the id of the weather status.
         * @return the id of the weather status.
         */
        public long getId() {
            return id;
        }

        /**
         * Returns the localized description of the weather
         * @return the localized description of the weather
         */
        public String getDescription() {
            return description;
        }
    }

    /**
     * The main information
     */
    @JsonData
    public static class Main {
        private double temp;
        private double humidity;
        private double pressure;

        /**
         * Returns the current temperature
         * @return the current temperature
         */
        public double getTemp() {
            return temp;
        }

        /**
         * Returns the current humidity
         * @return the current humidity
         */
        public double getHumidity() {
            return humidity;
        }

        /**
         * Returns the current pressure
         * @return the current pressure
         */
        public double getPressure() {
            return pressure;
        }

    }

    /**
     * The wind information
     */
    @JsonData
    public static class Wind {
        private double speed;
        private double deg;

        /**
         * Returns the wind speed
         * @return the wind speed
         */
        public double getSpeed() {
            return speed;
        }

        /**
         * Returns the direction of the wind in degrees
         * @return the direction of the wind in degrees
         */
        public double getDeg() {
            return deg;
        }

    }
}
